<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrderSpecialty extends Model 
{

    protected $table = 'order_specialty';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('order_id', 'specialty_id');

    public function order()
    {
        return $this->belongsTo('Order', 'order_id');
    }

    public function specialty()
    {
        return $this->belongsTo('Specialty', 'specialty_id');
    }

}