<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Store extends Eloquent {

	protected $table = 'store';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('password', 'name_en', 'name_ar', 'phone', 'email', 'city_id', 'from_year', 'to_year', 'whats_up', 'longitude', 'latitude', 'address_en', 'address_ar', 'user_id', 'country_id');

	public function brands()
	{
		return $this->belongsToMany('Brand', 'store_brand', 'store_id', 'brand_id');
	}

	public function models()
	{
		return $this->belongsToMany('CarModel', 'store_model', 'store_id', 'model_id');
	}

	public function specialties()
	{
		return $this->belongsToMany('Specialty', 'store_specialty', 'store_id', 'specialty_id');
	}

	public function city()
	{
		return $this->belongsTo('City', 'city_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function store_orders()
	{
		return $this->hasMany('StoreOrder', 'store_id');
	}

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

}