<?php

namespace App/Models/;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Shift extends Eloquent {

	protected $table = 'shifts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('start', 'end', 'setting_id', 'days_of_week_id', 'place_id');

	public function bookings()
	{
		return $this->hasMany('Booking');
	}

	public function dayOfWeek()
	{
		return $this->belongsTo('DayOfWeek');
	}

	public function place()
	{
		return $this->belongsTo('Place');
	}

	public function workingHourSetting()
	{
		return $this->belongsTo('WorkingHourSetting');
	}

}