<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('host_categories', function(Blueprint $table) {
			$table->foreign('host_id')->references('id')->on('hosts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('host_categories', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('expert_languages', function(Blueprint $table) {
			$table->foreign('expert_id')->references('id')->on('experts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('expert_days', function(Blueprint $table) {
			$table->foreign('expert_id')->references('id')->on('experts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('expert_documents', function(Blueprint $table) {
			$table->foreign('expert_id')->references('id')->on('experts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('expert_off_days', function(Blueprint $table) {
			$table->foreign('expert_id')->references('id')->on('experts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('package_items', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('packages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('package_items', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('expert_packages', function(Blueprint $table) {
			$table->foreign('expert_id')->references('id')->on('experts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('expert_packages', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('packages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('expert_package_reservations', function(Blueprint $table) {
			$table->foreign('host_id')->references('id')->on('hosts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('expert_package_reservations', function(Blueprint $table) {
			$table->foreign('expert_id')->references('id')->on('experts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('expert_package_reservations', function(Blueprint $table) {
			$table->foreign('expert_package_id')->references('id')->on('expert_packages')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('expert_package_reservation_items', function(Blueprint $table) {
			$table->foreign('expert_package_reservation_id')->references('id')->on('expert_package_reservations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('expert_package_reservation_items', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('expert_categories', function(Blueprint $table) {
			$table->foreign('expert_id')->references('id')->on('experts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('expert_categories', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_parent_id_foreign');
		});
		Schema::table('host_categories', function(Blueprint $table) {
			$table->dropForeign('host_categories_host_id_foreign');
		});
		Schema::table('host_categories', function(Blueprint $table) {
			$table->dropForeign('host_categories_category_id_foreign');
		});
		Schema::table('expert_languages', function(Blueprint $table) {
			$table->dropForeign('expert_languages_expert_id_foreign');
		});
		Schema::table('expert_days', function(Blueprint $table) {
			$table->dropForeign('expert_days_expert_id_foreign');
		});
		Schema::table('expert_documents', function(Blueprint $table) {
			$table->dropForeign('expert_documents_expert_id_foreign');
		});
		Schema::table('expert_off_days', function(Blueprint $table) {
			$table->dropForeign('expert_off_days_expert_id_foreign');
		});
		Schema::table('package_items', function(Blueprint $table) {
			$table->dropForeign('package_items_package_id_foreign');
		});
		Schema::table('package_items', function(Blueprint $table) {
			$table->dropForeign('package_items_service_id_foreign');
		});
		Schema::table('expert_packages', function(Blueprint $table) {
			$table->dropForeign('expert_packages_expert_id_foreign');
		});
		Schema::table('expert_packages', function(Blueprint $table) {
			$table->dropForeign('expert_packages_package_id_foreign');
		});
		Schema::table('expert_package_reservations', function(Blueprint $table) {
			$table->dropForeign('expert_package_reservations_host_id_foreign');
		});
		Schema::table('expert_package_reservations', function(Blueprint $table) {
			$table->dropForeign('expert_package_reservations_expert_id_foreign');
		});
		Schema::table('expert_package_reservations', function(Blueprint $table) {
			$table->dropForeign('expert_package_reservations_expert_package_id_foreign');
		});
		Schema::table('expert_package_reservation_items', function(Blueprint $table) {
			$table->dropForeign('expert_package_reservation_items_expert_package_reservation_id_foreign');
		});
		Schema::table('expert_package_reservation_items', function(Blueprint $table) {
			$table->dropForeign('expert_package_reservation_items_service_id_foreign');
		});
		Schema::table('expert_categories', function(Blueprint $table) {
			$table->dropForeign('expert_categories_expert_id_foreign');
		});
		Schema::table('expert_categories', function(Blueprint $table) {
			$table->dropForeign('expert_categories_category_id_foreign');
		});
	}
}