<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHostsTable extends Migration {

	public function up()
	{
		Schema::create('hosts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('token', 255);
			$table->json('meta');
			$table->string('allowed_ips', 255);
			$table->boolean('active')->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('hosts');
	}
}