<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('name', 'phone', 'email', 'password', 'date_of_birth', 'blood_type_id', 'last_donation_date', 'city_id', 'pin_code');

	public function BloodTypes()
	{
		return $this->belongsTo('App\Models\BloodType');
	}

	public function cities()
	{
		return $this->belongsTo('App\Models\City');
	}

	public function DonationRequests()
	{
		return $this->hasMany('App\Models\Donation_request');
	}

	public function BloodTypes()
	{
		return $this->belongsToMany('App\Models\BloodType');
	}

	public function notifications()
	{
		return $this->belongsToMany('App\Models\Notification');
	}

	public function posts()
	{
		return $this->belongsToMany('App\Models\Post');
	}

	public function governorates()
	{
		return $this->belongsToMany('App\Models\Governorate');
	}

}