<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('articles', function(Blueprint $table) {
			$table->foreign('author_id')->references('id')->on('author')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('article_media', function(Blueprint $table) {
			$table->foreign('article_id')->references('id')->on('articles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('article_media', function(Blueprint $table) {
			$table->foreign('media_id')->references('id')->on('medias')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_preference', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('tags')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_preference', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_preference', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('article_likes', function(Blueprint $table) {
			$table->foreign('article_id')->references('id')->on('articles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('article_likes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('article_comment', function(Blueprint $table) {
			$table->foreign('article_id')->references('id')->on('articles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('article_comment', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_auth_token', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('articles', function(Blueprint $table) {
			$table->dropForeign('articles_author_id_foreign');
		});
		Schema::table('article_media', function(Blueprint $table) {
			$table->dropForeign('article_media_article_id_foreign');
		});
		Schema::table('article_media', function(Blueprint $table) {
			$table->dropForeign('article_media_media_id_foreign');
		});
		Schema::table('user_preference', function(Blueprint $table) {
			$table->dropForeign('user_preference_tag_id_foreign');
		});
		Schema::table('user_preference', function(Blueprint $table) {
			$table->dropForeign('user_preference_category_id_foreign');
		});
		Schema::table('user_preference', function(Blueprint $table) {
			$table->dropForeign('user_preference_user_id_foreign');
		});
		Schema::table('article_likes', function(Blueprint $table) {
			$table->dropForeign('article_likes_article_id_foreign');
		});
		Schema::table('article_likes', function(Blueprint $table) {
			$table->dropForeign('article_likes_user_id_foreign');
		});
		Schema::table('article_comment', function(Blueprint $table) {
			$table->dropForeign('article_comment_article_id_foreign');
		});
		Schema::table('article_comment', function(Blueprint $table) {
			$table->dropForeign('article_comment_user_id_foreign');
		});
		Schema::table('user_auth_token', function(Blueprint $table) {
			$table->dropForeign('user_auth_token_user_id_foreign');
		});
	}
}