<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 50);
			$table->enum('type', array('practical', 'theoretical', 'hybrid'));
			$table->integer('department_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}