<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWorkingHoursTable extends Migration {

	public function up()
	{
		Schema::create('working_hours', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->nullable();
			$table->datetime('date')->nullable();
			$table->integer('minutes')->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('working_hours');
	}
}