<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class City extends Eloquent {

	protected $table = 'city';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name');

	public function towers()
	{
		return $this->hasMany('Tower', 'city_id');
	}

}