<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class InvoiceHistory extends Eloquent {

	protected $table = 'invoice_history';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('status', 'user_id', 'invoice_id');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function invoice()
	{
		return $this->belongsTo('Invoice', 'invoice_id');
	}

}