<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Tower extends Eloquent {

	protected $table = 'tower';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'description', 'city_id');

	public function city()
	{
		return $this->belongsTo('City', 'city_id');
	}

	public function subscriptions()
	{
		return $this->hasMany('Subscription', 'tower_id');
	}

}