<?php

namespace user;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'user';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function subscriptions()
	{
		return $this->hasMany('Subscription', 'client_id');
	}

}