<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class InvoiceHistory extends Model 
{

    protected $table = 'invoice_history';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('status', 'user_id', 'invoice_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function invoice()
    {
        return $this->belongsTo('Invoice', 'invoice_id');
    }

}