<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SubscriptionNote extends Model 
{

    protected $table = 'subscription_note';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('subscription_id', 'note', 'user_id');

    public function subscription()
    {
        return $this->belongsTo('Subscription', 'subscription_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}