<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 155);
			$table->string('phone')->unique();
			$table->string('email');
			$table->string('password')->nullable();
			$table->string('image');
			$table->enum('status', array('active', 'inactive'))->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}