<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('password');
			$table->string('email', 255);
			$table->string('mobile', 255);
			$table->string('token', 255);
			$table->integer('status');
			$table->datetime('login_at');
			$table->string('created_at');
			$table->datetime('updated_at');
			$table->integer('role_id')->unsigned();
			$table->string('mark', 1024);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}