<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('admin_users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('org_id')->references('id')->on('organizations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->foreign('org_id')->references('id')->on('organizations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('classrooms', function(Blueprint $table) {
			$table->foreign('org_id')->references('id')->on('organizations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->foreign('org_id')->references('id')->on('organizations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('course_breakdown', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('course_series', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('organ_label', function(Blueprint $table) {
			$table->foreign('org_id')->references('id')->on('organizations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('organ_label', function(Blueprint $table) {
			$table->foreign('label')->references('id')->on('series')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campaign_series', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaigns')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campaign_series', function(Blueprint $table) {
			$table->foreign('series_id')->references('id')->on('series')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('admin_users', function(Blueprint $table) {
			$table->dropForeign('admin_users_role_id_foreign');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_org_id_foreign');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->dropForeign('campaigns_org_id_foreign');
		});
		Schema::table('classrooms', function(Blueprint $table) {
			$table->dropForeign('classrooms_org_id_foreign');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->dropForeign('roles_org_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('course_breakdown', function(Blueprint $table) {
			$table->dropForeign('course_breakdown_course_id_foreign');
		});
		Schema::table('course_series', function(Blueprint $table) {
			$table->dropForeign('course_series_course_id_foreign');
		});
		Schema::table('organ_label', function(Blueprint $table) {
			$table->dropForeign('organ_label_org_id_foreign');
		});
		Schema::table('organ_label', function(Blueprint $table) {
			$table->dropForeign('organ_label_label_foreign');
		});
		Schema::table('campaign_series', function(Blueprint $table) {
			$table->dropForeign('campaign_series_campaign_id_foreign');
		});
		Schema::table('campaign_series', function(Blueprint $table) {
			$table->dropForeign('campaign_series_series_id_foreign');
		});
	}
}