<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('first_name', 'last_name', 'email', 'password');

	public function events()
	{
		return $this->belongsToMany('App\Event');
	}

	public function refunds()
	{
		return $this->hasMany('App\Refund');
	}

	public function transactions()
	{
		return $this->hasMany('App\Transaction');
	}

}