<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfilesTable extends Migration {

	public function up()
	{
		Schema::create('profiles', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('display_name', 128);
			$table->string('title', 255)->nullable();
			$table->string('forename', 255)->nullable();
			$table->string('surname', 255)->nullable();
			$table->date('dob')->nullable();
			$table->string('mobile', 255)->nullable();
			$table->string('address_1', 255)->nullable();
			$table->string('address_2', 255)->nullable();
			$table->string('address_3', 255)->nullable();
			$table->string('address_city', 255)->nullable();
			$table->string('address_postcode', 255);
		});
	}

	public function down()
	{
		Schema::drop('profiles');
	}
}