<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('profile_id');
			$table->timestamps();
			$table->integer('status')->default('0');
			$table->string('email', 255);
			$table->string('password');
			$table->datetime('last_active_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}