<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePropertyInfoTable extends Migration {

	public function up()
	{
		Schema::create('property_info', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('property_id')->unsigned();
			$table->string('bed_room')->nullable();
			$table->string('storey')->nullable();
			$table->integer('garage')->nullable();
			$table->boolean('is_active')->default(1);
			$table->bigInteger('create_user_id')->unsigned();
			$table->bigInteger('edit_user_id')->unsigned()->nullable();
			$table->bigInteger('location_id')->unsigned()->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('property_info');
	}
}