<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('set_price_ranges', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('set_location')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('set_price_ranges', function(Blueprint $table) {
			$table->foreign('create_user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('set_price_ranges', function(Blueprint $table) {
			$table->foreign('edit_user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('set_suburbs', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('set_states')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('set_suburbs', function(Blueprint $table) {
			$table->foreign('location')->references('id')->on('set_location')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('set_suburbs', function(Blueprint $table) {
			$table->foreign('create_user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('set_suburbs', function(Blueprint $table) {
			$table->foreign('edit_user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('set_states', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('set_countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('set_states', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('set_location')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('set_states', function(Blueprint $table) {
			$table->foreign('create_user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('set_states', function(Blueprint $table) {
			$table->foreign('edit_user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_suburb', function(Blueprint $table) {
			$table->foreign('suburb_id')->references('id')->on('set_suburbs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_suburb', function(Blueprint $table) {
			$table->foreign('user_profile_id')->references('id')->on('user_survey_profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('set_location', function(Blueprint $table) {
			$table->foreign('create_user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('set_location', function(Blueprint $table) {
			$table->foreign('edit_user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('set_countries', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('set_location')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('set_countries', function(Blueprint $table) {
			$table->foreign('create_user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('set_countries', function(Blueprint $table) {
			$table->foreign('edit_user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_survey_profiles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('set_schools', function(Blueprint $table) {
			$table->foreign('suburb_id')->references('id')->on('set_suburbs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('set_schools', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('set_location')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('set_schools', function(Blueprint $table) {
			$table->foreign('create_user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('set_schools', function(Blueprint $table) {
			$table->foreign('edit_user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('properties', function(Blueprint $table) {
			$table->foreign('create_user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('properties', function(Blueprint $table) {
			$table->foreign('edit_user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('properties', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('set_location')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('property_address', function(Blueprint $table) {
			$table->foreign('property_id')->references('id')->on('properties')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('property_address', function(Blueprint $table) {
			$table->foreign('suburb_id')->references('id')->on('set_suburbs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('property_address', function(Blueprint $table) {
			$table->foreign('create_user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('property_address', function(Blueprint $table) {
			$table->foreign('edit_user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('property_address', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('set_location')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('property_info', function(Blueprint $table) {
			$table->foreign('property_id')->references('id')->on('properties')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('property_info', function(Blueprint $table) {
			$table->foreign('create_user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('property_info', function(Blueprint $table) {
			$table->foreign('edit_user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('property_info', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('set_location')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('property_user', function(Blueprint $table) {
			$table->foreign('property_id')->references('id')->on('properties')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('property_user', function(Blueprint $table) {
			$table->foreign('user_profile_id')->references('timestamps')->on('user_survey_profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('property_user', function(Blueprint $table) {
			$table->foreign('create_user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('property_user', function(Blueprint $table) {
			$table->foreign('edit_user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('property_user', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('set_location')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('more_refine_search', function(Blueprint $table) {
			$table->foreign('user_survey_profile_id')->references('id')->on('user_survey_profiles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('more_refine_search', function(Blueprint $table) {
			$table->foreign('school_id')->references('id')->on('set_schools')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_price_renge', function(Blueprint $table) {
			$table->foreign('user_profile_id')->references('id')->on('user_survey_profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_price_renge', function(Blueprint $table) {
			$table->foreign('price_renge_id')->references('id')->on('set_price_ranges')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_property_type', function(Blueprint $table) {
			$table->foreign('user_profile_id')->references('id')->on('user_survey_profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('User_bed_room', function(Blueprint $table) {
			$table->foreign('user_profile_id')->references('id')->on('user_survey_profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_move_in', function(Blueprint $table) {
			$table->foreign('user_profile_id')->references('id')->on('user_survey_profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('property_image', function(Blueprint $table) {
			$table->foreign('property_id')->references('id')->on('properties')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('set_price_ranges', function(Blueprint $table) {
			$table->dropForeign('set_price_ranges_location_id_foreign');
		});
		Schema::table('set_price_ranges', function(Blueprint $table) {
			$table->dropForeign('set_price_ranges_create_user_id_foreign');
		});
		Schema::table('set_price_ranges', function(Blueprint $table) {
			$table->dropForeign('set_price_ranges_edit_user_id_foreign');
		});
		Schema::table('set_suburbs', function(Blueprint $table) {
			$table->dropForeign('set_suburbs_state_id_foreign');
		});
		Schema::table('set_suburbs', function(Blueprint $table) {
			$table->dropForeign('set_suburbs_location_foreign');
		});
		Schema::table('set_suburbs', function(Blueprint $table) {
			$table->dropForeign('set_suburbs_create_user_id_foreign');
		});
		Schema::table('set_suburbs', function(Blueprint $table) {
			$table->dropForeign('set_suburbs_edit_user_id_foreign');
		});
		Schema::table('set_states', function(Blueprint $table) {
			$table->dropForeign('set_states_country_id_foreign');
		});
		Schema::table('set_states', function(Blueprint $table) {
			$table->dropForeign('set_states_location_id_foreign');
		});
		Schema::table('set_states', function(Blueprint $table) {
			$table->dropForeign('set_states_create_user_id_foreign');
		});
		Schema::table('set_states', function(Blueprint $table) {
			$table->dropForeign('set_states_edit_user_id_foreign');
		});
		Schema::table('user_suburb', function(Blueprint $table) {
			$table->dropForeign('user_suburb_suburb_id_foreign');
		});
		Schema::table('user_suburb', function(Blueprint $table) {
			$table->dropForeign('user_suburb_user_profile_id_foreign');
		});
		Schema::table('set_location', function(Blueprint $table) {
			$table->dropForeign('set_location_create_user_id_foreign');
		});
		Schema::table('set_location', function(Blueprint $table) {
			$table->dropForeign('set_location_edit_user_id_foreign');
		});
		Schema::table('set_countries', function(Blueprint $table) {
			$table->dropForeign('set_countries_location_id_foreign');
		});
		Schema::table('set_countries', function(Blueprint $table) {
			$table->dropForeign('set_countries_create_user_id_foreign');
		});
		Schema::table('set_countries', function(Blueprint $table) {
			$table->dropForeign('set_countries_edit_user_id_foreign');
		});
		Schema::table('user_survey_profiles', function(Blueprint $table) {
			$table->dropForeign('user_survey_profiles_user_id_foreign');
		});
		Schema::table('set_schools', function(Blueprint $table) {
			$table->dropForeign('set_schools_suburb_id_foreign');
		});
		Schema::table('set_schools', function(Blueprint $table) {
			$table->dropForeign('set_schools_location_id_foreign');
		});
		Schema::table('set_schools', function(Blueprint $table) {
			$table->dropForeign('set_schools_create_user_id_foreign');
		});
		Schema::table('set_schools', function(Blueprint $table) {
			$table->dropForeign('set_schools_edit_user_id_foreign');
		});
		Schema::table('properties', function(Blueprint $table) {
			$table->dropForeign('properties_create_user_id_foreign');
		});
		Schema::table('properties', function(Blueprint $table) {
			$table->dropForeign('properties_edit_user_id_foreign');
		});
		Schema::table('properties', function(Blueprint $table) {
			$table->dropForeign('properties_location_id_foreign');
		});
		Schema::table('property_address', function(Blueprint $table) {
			$table->dropForeign('property_address_property_id_foreign');
		});
		Schema::table('property_address', function(Blueprint $table) {
			$table->dropForeign('property_address_suburb_id_foreign');
		});
		Schema::table('property_address', function(Blueprint $table) {
			$table->dropForeign('property_address_create_user_id_foreign');
		});
		Schema::table('property_address', function(Blueprint $table) {
			$table->dropForeign('property_address_edit_user_id_foreign');
		});
		Schema::table('property_address', function(Blueprint $table) {
			$table->dropForeign('property_address_location_id_foreign');
		});
		Schema::table('property_info', function(Blueprint $table) {
			$table->dropForeign('property_info_property_id_foreign');
		});
		Schema::table('property_info', function(Blueprint $table) {
			$table->dropForeign('property_info_create_user_id_foreign');
		});
		Schema::table('property_info', function(Blueprint $table) {
			$table->dropForeign('property_info_edit_user_id_foreign');
		});
		Schema::table('property_info', function(Blueprint $table) {
			$table->dropForeign('property_info_location_id_foreign');
		});
		Schema::table('property_user', function(Blueprint $table) {
			$table->dropForeign('property_user_property_id_foreign');
		});
		Schema::table('property_user', function(Blueprint $table) {
			$table->dropForeign('property_user_user_profile_id_foreign');
		});
		Schema::table('property_user', function(Blueprint $table) {
			$table->dropForeign('property_user_create_user_id_foreign');
		});
		Schema::table('property_user', function(Blueprint $table) {
			$table->dropForeign('property_user_edit_user_id_foreign');
		});
		Schema::table('property_user', function(Blueprint $table) {
			$table->dropForeign('property_user_location_id_foreign');
		});
		Schema::table('more_refine_search', function(Blueprint $table) {
			$table->dropForeign('more_refine_search_user_survey_profile_id_foreign');
		});
		Schema::table('more_refine_search', function(Blueprint $table) {
			$table->dropForeign('more_refine_search_school_id_foreign');
		});
		Schema::table('user_price_renge', function(Blueprint $table) {
			$table->dropForeign('user_price_renge_user_profile_id_foreign');
		});
		Schema::table('user_price_renge', function(Blueprint $table) {
			$table->dropForeign('user_price_renge_price_renge_id_foreign');
		});
		Schema::table('user_property_type', function(Blueprint $table) {
			$table->dropForeign('user_property_type_user_profile_id_foreign');
		});
		Schema::table('User_bed_room', function(Blueprint $table) {
			$table->dropForeign('User_bed_room_user_profile_id_foreign');
		});
		Schema::table('user_move_in', function(Blueprint $table) {
			$table->dropForeign('user_move_in_user_profile_id_foreign');
		});
		Schema::table('property_image', function(Blueprint $table) {
			$table->dropForeign('property_image_property_id_foreign');
		});
	}
}