<?php

namespace Property;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Property extends Model 
{

    protected $table = 'properties';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function property_address()
    {
        return $this->hasOne('PropertyAddress');
    }

    public function property_info()
    {
        return $this->hasOne('PropertyInfo');
    }

    public function property_user()
    {
        return $this->belongsToMany('PropertyUser');
    }

    public function property_image()
    {
        return $this->hasMany('ProperttyImage');
    }

}