<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePropertiesTable extends Migration {

	public function up()
	{
		Schema::create('properties', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title')->nullable();
			$table->string('type')->nullable();
			$table->string('price');
			$table->string('bed_room');
			$table->string('bath_room');
			$table->string('garage');
			$table->string('address')->nullable();
			$table->datetime('availability_from')->nullable();
			$table->datetime('availability_to')->nullable();
			$table->boolean('is_active')->default(1);
			$table->bigInteger('create_user_id')->unsigned()->nullable();
			$table->bigInteger('edit_user_id')->unsigned()->nullable();
			$table->bigInteger('location_id')->unsigned()->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('properties');
	}
}