<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePropertyAddressTable extends Migration {

	public function up()
	{
		Schema::create('property_address', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('property_id')->unsigned()->nullable();
			$table->bigInteger('suburb_id')->unsigned()->nullable();
			$table->string('street')->nullable();
			$table->string('city')->nullable();
			$table->string('po_box')->nullable();
			$table->boolean('is_active')->default(1);
			$table->bigInteger('create_user_id')->unsigned()->nullable();
			$table->bigInteger('edit_user_id')->unsigned()->nullable();
			$table->bigInteger('location_id')->unsigned()->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('property_address');
	}
}