<?php

namespace App\Models\Reference;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Accreditation extends Eloquent {

	protected $table = 'accreditations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function services()
	{
		return $this->belongsToMany('Service', 'service_accreditation', 'accreditation_id', 'service_id')->withTimestamps();
	}

}