<?php

namespace App\Models\Reference;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Material extends Eloquent {

	protected $table = 'materials';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $hidden = array('timestamps', 'softDeletes');

	public function materialType()
	{
		return $this->belongsTo('MaterialType', 'id', 'material_type_id');
	}

	public function services()
	{
		return $this->belongsToMany('Service', 'service_material', 'material_id', 'service_id')->withTimestamps();
	}

	public function technologies()
	{
		return $this->belongsToMany('Technology', 'technology_material', 'material_id', 'technology_id')->withTimestamps();
	}

}