<?php

namespace App\Models\Reference;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Service extends Eloquent {

	protected $table = 'services';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $hidden = array('timestamps', 'softDeletes');

	public function materials()
	{
		return $this->belongsToMany('Material', 'service_material', 'service_id', 'material_id')->withTimestamps();
	}

}