<?php

namespace App\Models\Reference;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Thickness extends Eloquent {

	protected $table = 'thicknesses';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function services()
	{
		return $this->belongsToMany('Service', 'service_thickness', 'thickness_id', 'service_id')->withTimestamps();
	}

	public function materials()
	{
		return $this->belongsToMany('Material', 'material_thickness', 'thickness_id', 'material_id')->withTimestamps();
	}

}