<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('country_code')->references('code')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('department_code')->references('code')->on('departments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('municipality_code')->references('code')->on('municipalities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->foreign('coupon_Id')->references('id')->on('coupons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tests', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tests', function(Blueprint $table) {
			$table->foreign('purchase_id')->references('id')->on('purchases')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('test_id')->references('id')->on('tests')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('question_code')->references('code')->on('questions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('programs', function(Blueprint $table) {
			$table->foreign('institution_SNIES_code')->references('SNIES_code')->on('institutions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('programs', function(Blueprint $table) {
			$table->foreign('municipality_code')->references('code')->on('municipalities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('municipalities', function(Blueprint $table) {
			$table->foreign('department_code')->references('code')->on('departments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('departments', function(Blueprint $table) {
			$table->foreign('country_code')->references('code')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->foreign('test_id')->references('id')->on('tests')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_country_code_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_department_code_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_municipality_code_foreign');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->dropForeign('purchases_user_id_foreign');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->dropForeign('purchases_coupon_Id_foreign');
		});
		Schema::table('tests', function(Blueprint $table) {
			$table->dropForeign('tests_user_id_foreign');
		});
		Schema::table('tests', function(Blueprint $table) {
			$table->dropForeign('tests_purchase_id_foreign');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_test_id_foreign');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_question_code_foreign');
		});
		Schema::table('programs', function(Blueprint $table) {
			$table->dropForeign('programs_institution_SNIES_code_foreign');
		});
		Schema::table('programs', function(Blueprint $table) {
			$table->dropForeign('programs_municipality_code_foreign');
		});
		Schema::table('municipalities', function(Blueprint $table) {
			$table->dropForeign('municipalities_department_code_foreign');
		});
		Schema::table('departments', function(Blueprint $table) {
			$table->dropForeign('departments_country_code_foreign');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->dropForeign('ratings_test_id_foreign');
		});
	}
}