<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('City_id')->references('id')->on('Cites')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('Cites', function(Blueprint $table) {
			$table->foreign('Governorate_id')->references('id')->on('Governorates')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('Posts', function(Blueprint $table) {
			$table->foreign('thumbnail_id')->references('id')->on('thumbnails')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('donations', function(Blueprint $table) {
			$table->foreign('blood_type_id')->references('id')->on('Blood_types')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('Notfications', function(Blueprint $table) {
			$table->foreign('donation_id')->references('id')->on('donations')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('Clients_notifications', function(Blueprint $table) {
			$table->foreign('Client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('Clients_notifications', function(Blueprint $table) {
			$table->foreign('Notification_id')->references('id')->on('Notfications')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('Favourites', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('Posts')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('Favourites', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('clientables', function(Blueprint $table) {
			$table->foreign('clint_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_City_id_foreign');
		});
		Schema::table('Cites', function(Blueprint $table) {
			$table->dropForeign('Cites_Governorate_id_foreign');
		});
		Schema::table('Posts', function(Blueprint $table) {
			$table->dropForeign('Posts_thumbnail_id_foreign');
		});
		Schema::table('donations', function(Blueprint $table) {
			$table->dropForeign('donations_blood_type_id_foreign');
		});
		Schema::table('Notfications', function(Blueprint $table) {
			$table->dropForeign('Notfications_donation_id_foreign');
		});
		Schema::table('Clients_notifications', function(Blueprint $table) {
			$table->dropForeign('Clients_notifications_Client_id_foreign');
		});
		Schema::table('Clients_notifications', function(Blueprint $table) {
			$table->dropForeign('Clients_notifications_Notification_id_foreign');
		});
		Schema::table('Favourites', function(Blueprint $table) {
			$table->dropForeign('Favourites_post_id_foreign');
		});
		Schema::table('Favourites', function(Blueprint $table) {
			$table->dropForeign('Favourites_client_id_foreign');
		});
		Schema::table('clientables', function(Blueprint $table) {
			$table->dropForeign('clientables_clint_id_foreign');
		});
	}
}