<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeesTable extends Migration {

	public function up()
	{
		Schema::create('employees', function(Blueprint $table) {
			$table->increments('id');
			$table->string('uuid');
			$table->string('number');
			$table->string('name');
			$table->string('title');
			$table->enum('gender', array('M', 'F'));
			$table->string('pob');
			$table->date('dob');
			$table->string('nik');
			$table->text('address');
			$table->integer('city_id');
			$table->string('zip_code');
			$table->string('phone');
			$table->string('email');
			$table->string('join_year');
			$table->integer('is_active');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('employees');
	}
}