<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Events extends Eloquent {

	protected $table = 'events';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('event_id', 'name', 'production_name', 'city', 'venue', 'event_date', 'ct_event_date', 'data', 'is_active');

	public function getTickets()
	{
		return $this->hasMany('Tickets', 'event_id');
	}

}