<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePayoutsTable extends Migration {

	public function up()
	{
		Schema::create('payouts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('sale_id')->unsigned();
			$table->string('amount')->nullable();
			$table->string('payment_id')->nullable();
			$table->string('transaction_id')->nullable();
			$table->integer('created_by')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('payouts');
	}
}