<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSalesTable extends Migration {

	public function up()
	{
		Schema::create('sales', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('ticket_id')->unsigned();
			$table->integer('buyer_id')->unsigned()->nullable();
			$table->integer('seller_id')->unsigned();
			$table->string('date')->nullable();
			$table->string('quantity')->nullable();
			$table->string('total_price')->nullable();
			$table->string('price_actual')->nullable();
			$table->string('commission_amount')->nullable();
			$table->string('payment_id')->nullable();
			$table->string('transaction_id')->nullable();
			$table->string('payment_status')->nullable();
			$table->integer('seller_status')->unsigned();
			$table->integer('buyer_status')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('sales');
	}
}