<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDealsTable extends Migration {

	public function up()
	{
		Schema::create('deals', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 120);
			$table->string('description', 512);
			$table->float('price');
			$table->integer('discount')->unsigned();
			$table->datetime('endDate');
			$table->string('hashtags', 155);
			$table->string('terms', 512);
			$table->integer('place_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('deals');
	}
}