<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 55);
			$table->string('description', 1024);
			$table->string('hashtags', 255);
			$table->date('date');
			$table->time('fromHour');
			$table->time('toHour')->nullable();
			$table->decimal('lat', 10,8)->nullable();
			$table->decimal('long', 11,8)->nullable();
			$table->integer('eventeable_id')->unsigned()->nullable();
			$table->string('eventeable_type')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}