<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlacesTypesTable extends Migration {

	public function up()
	{
		Schema::create('places_types', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 50);
			$table->string('tags', 255)->nullable();
			$table->boolean('canHaveDeals')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('places_types');
	}
}