<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('places', function(Blueprint $table) {
			$table->foreign('id_contact_info')->references('id')->on('contact_info')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('places', function(Blueprint $table) {
			$table->foreign('place_type_id')->references('id')->on('places_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('review_items', function(Blueprint $table) {
			$table->foreign('review_criteria_id')->references('id')->on('review_criterias')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('review_items', function(Blueprint $table) {
			$table->foreign('review_id')->references('id')->on('reviews')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('criteriables', function(Blueprint $table) {
			$table->foreign('review_criteria_id')->references('id')->on('review_criterias')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('deals', function(Blueprint $table) {
			$table->foreign('place_id')->references('id')->on('places')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contents', function(Blueprint $table) {
			$table->foreign('content_type_id')->references('id')->on('contents_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('places', function(Blueprint $table) {
			$table->dropForeign('places_id_contact_info_foreign');
		});
		Schema::table('places', function(Blueprint $table) {
			$table->dropForeign('places_place_type_id_foreign');
		});
		Schema::table('review_items', function(Blueprint $table) {
			$table->dropForeign('review_items_review_criteria_id_foreign');
		});
		Schema::table('review_items', function(Blueprint $table) {
			$table->dropForeign('review_items_review_id_foreign');
		});
		Schema::table('criteriables', function(Blueprint $table) {
			$table->dropForeign('criteriables_review_criteria_id_foreign');
		});
		Schema::table('deals', function(Blueprint $table) {
			$table->dropForeign('deals_place_id_foreign');
		});
		Schema::table('contents', function(Blueprint $table) {
			$table->dropForeign('contents_content_type_id_foreign');
		});
	}
}