<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Customer extends Model 
{

    protected $table = 'customers';
    public $timestamps = true;

    public function salesOrder()
    {
        return $this->hasOne('SaleOrder');
    }

    public function salesInvoice()
    {
        return $this->hasOne('SaleInvoice');
    }

    public function purchaseOrder()
    {
        return $this->hasOne('PurchaseOrder');
    }

    public function payment()
    {
        return $this->hasOne('Payment');
    }

    public function address()
    {
        return $this->hasOne('Adress');
    }

    public function items()
    {
        return $this->hasMany('Item');
    }

    public function shipment()
    {
        return $this->hasOne('Shipment');
    }

}