<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('holding_id')->unsigned()->nullable();
			$table->string('name');
			$table->string('code');
			$table->string('common_name');
			$table->string('email');
			$table->string('phone');
			$table->string('reg_number');
			$table->string('tax_number');
			$table->mediumText('note');
			$table->string('identifier');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}