<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemsTable extends Migration {

	public function up()
	{
		Schema::create('items', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->text('description');
			$table->string('technical_description');
			$table->integer('supplier_id');
			$table->integer('external_id');
			$table->boolean('active')->default(1);
			$table->boolean('record_only')->default(0);
			$table->integer('category_id');
			$table->string('warranty');
			$table->integer('department_id');
			$table->string('primary_um');
			$table->integer('net_weight');
			$table->integer('gross_weight');
			$table->integer('width');
			$table->integer('height');
			$table->integer('depth');
			$table->string('um');
			$table->integer('suppliers_price');
			$table->integer('suppliers_discount');
			$table->integer('transport');
			$table->integer('customs');
			$table->integer('vat');
			$table->string('image_url');
			$table->integer('av_stock');
			$table->integer('min_stock');
			$table->string('warehouse');
			$table->string('selected_warehouse');
			$table->string('other_warehouse');
			$table->integer('stock_total');
			$table->string('sn_tracking');
			$table->string('s_warehouse');
			$table->string('s_table');
			$table->string('from_date');
			$table->string('to_date');
			$table->string('filter');
			$table->string('specification');
			$table->string('specs_warehouse');
			$table->string('specs_list');
			$table->integer('customer_id')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('items');
	}
}