<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShipmentsTable extends Migration {

	public function up()
	{
		Schema::create('shipments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('num');
			$table->string('date');
			$table->string('currency');
			$table->integer('days_to_pay');
			$table->string('deliver_by');
			$table->string('responsible');
			$table->integer('customer_id')->unsigned();
			$table->string('customer_display');
			$table->string('deliver_by_date');
			$table->integer('transport_cost');
			$table->integer('vat_percent');
			$table->integer('vat');
			$table->integer('total_cost');
			$table->text('note');
			$table->string('obs');
		});
	}

	public function down()
	{
		Schema::drop('shipments');
	}
}