<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('payments', function(Blueprint $table) {
			$table->increments('id');
			$table->string('report_date');
			$table->string('due_from');
			$table->string('to');
			$table->boolean('outstanding_invoice_all')->default(0);
			$table->boolean('outstanding_invoice_029')->default(0);
			$table->boolean('outstanding_invoice_3059')->default(0);
			$table->boolean('outstanding_invoice_over_60')->default(0);
			$table->string('currency');
			$table->string('convert_to');
			$table->integer('customer_id')->unsigned()->nullable();
			$table->string('customer_exchange_rate');
			$table->string('customer_document');
			$table->string('customer_status');
			$table->integer('supplier_id')->unsigned()->nullable();
			$table->string('supplier_exchange_rate');
			$table->string('supplier_document');
			$table->string('supplier_status');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('payments');
	}
}