<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSalesOrdersTable extends Migration {

	public function up()
	{
		Schema::create('salesOrders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('number');
			$table->string('date');
			$table->string('currency');
			$table->integer('days_to_pay');
			$table->string('deliver_by');
			$table->string('responsible');
			$table->integer('customer_id')->unsigned()->nullable();
			$table->string('customer_display');
			$table->string('contact_person');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('salesOrders');
	}
}