<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code');
			$table->string('name');
			$table->text('description');
			$table->boolean('active')->default(1);
			$table->boolean('record_only')->default(0);
			$table->text('detailed_description');
			$table->integer('address_id')->unsigned();
			$table->string('contact_person');
			$table->string('phone');
			$table->string('email');
			$table->string('tax_number');
			$table->string('other_info');
			$table->integer('item_id')->unsigned();
			$table->integer('price');
			$table->string('currency');
			$table->integer('discount');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}