<?php

namespace App\Models;

class Category extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;
	protected $fillable = array('name', 'level', 'slug', 'parent_id', 'description', 'view_home');

	public function childs()
	{
		return $this->hasMany('App\Models\Category', 'parent_id');
	}

	public function parent()
	{
		return $this->belongsTo('App\Models\Category');
	}

	public function products()
	{
		return $this->belongsToMany('App\Models\Product');
	}

}