<?php

namespace App\Models;

class City extends Eloquent {

	protected $table = 'cities';
	public $timestamps = true;
	protected $fillable = array('country_id', 'name');

	public function country()
	{
		return $this->belongsTo('App\Models\Country');
	}

	public function clients()
	{
		return $this->belongsToMany('App\Models\Client');
	}

	public function client()
	{
		return $this->hasMany('App\Models\Client');
	}

}