<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('city_id', 'name', 'phone', 'email', 'gender', 'password');

	public function addresses()
	{
		return $this->belongsToMany('App\Models\City');
	}

	public function city()
	{
		return $this->belongsTo('App\Models\City');
	}

	public function orders()
	{
		return $this->hasMany('App\Models\Order');
	}

	public function products()
	{
		return $this->belongsToMany('App\Models\Product');
	}

	public function notifications()
	{
		return $this->belongsToMany('App\Models\Notification');
	}

	public function reviews()
	{
		return $this->hasMany('App\Models\Review');
	}

	public function tokens()
	{
		return $this->hasMany('App\Models\Token');
	}

	public function contacts()
	{
		return $this->hasMany('App\Models\Contact');
	}

	public function join_marketing_requests()
	{
		return $this->hasMany('App\Models\JoinMarketingRequest');
	}

	public function complaints()
	{
		return $this->hasMany('App\Models\ComplaintReasonProduct');
	}

}